import 'package:get/get.dart';
import 'package:shared_preferences/shared_preferences.dart';
import 'package:viser_remit/core/helper/shared_preference_helper.dart';
import 'package:viser_remit/push_notification_service.dart';
import 'package:viser_remit/view/components/preview_image/preview_image.dart';
import 'package:viser_remit/view/screens/account/change-password/change_password_screen.dart';
import 'package:viser_remit/view/screens/auth/email_verification_page/email_verification_screen.dart';
import 'package:viser_remit/view/screens/auth/forget_password/forget_password/forget_password.dart';
import 'package:viser_remit/view/screens/auth/forget_password/reset_password/reset_password_screen.dart';
import 'package:viser_remit/view/screens/auth/forget_password/verify_forget_password/verify_forget_password_screen.dart';
import 'package:viser_remit/view/screens/auth/kyc/kyc.dart';
import 'package:viser_remit/view/screens/auth/login/login_screen.dart';
import 'package:viser_remit/view/screens/auth/profile_complete/profile_complete_screen.dart';
import 'package:viser_remit/view/screens/auth/registration/registration_screen.dart';
import 'package:viser_remit/view/screens/auth/sms_verification_page/sms_verification_screen.dart';
import 'package:viser_remit/view/screens/bottom_nav_section/profile/profile_screen.dart';
import 'package:viser_remit/view/screens/edit_profile/edit_profile_screen.dart';
import 'package:viser_remit/view/screens/faq/faq_screen.dart';
import 'package:viser_remit/view/screens/language/language_screen.dart';
import 'package:viser_remit/view/screens/onboard/onboard_screen.dart';
import 'package:viser_remit/view/screens/privacy_policy/privacy_policy_screen.dart';
import 'package:viser_remit/view/screens/send_money/recipient_screen.dart';
import 'package:viser_remit/view/screens/send_money/send_money_screen.dart';
import 'package:viser_remit/view/screens/send_money/sender_screen.dart';
import 'package:viser_remit/view/screens/send_money_history/send_money_history_details.dart';
import 'package:viser_remit/view/screens/send_money_history/send_money_history_screen.dart';
import 'package:viser_remit/view/screens/splash/splash_screen.dart';
import 'package:viser_remit/view/screens/ticket/all_ticket_screen/all_ticket_screen.dart';
import 'package:viser_remit/view/screens/ticket/new_ticket_screen/new_ticket_screen.dart';
import 'package:viser_remit/view/screens/ticket/ticket_details_screen/ticket_details_screen.dart';
import 'package:viser_remit/view/screens/transection/transection_screen.dart';
import 'package:viser_remit/view/screens/two_factor/two_factor_verification_screen/two_factor_verification_screen.dart';

import '../../data/model/user/user.dart';
import '../../view/components/bottom-nav-bar/bottom_navbar_2.dart';
import '../../view/screens/deposits/deposit_webview/my_webview_screen.dart';
import '../../view/screens/deposits/new_deposit/new_deposit_screen.dart';
import '../../view/screens/two_factor/two_factor_setup_screen/two_factor_setup_screen.dart';

class RouteHelper {
  static const String splashScreen                  = "/splash_screen";
  static const String loginScreen                   = "/login_screen";
  static const String forgotPasswordScreen          = "/forgot_password_screen";
  static const String changePasswordScreen          = "/change_password_screen";
  static const String registrationScreen            = "/registration_screen";
  static const String bottomNavBar                  = "/bottom_nav_bar";
  static const String profileCompleteScreen         = "/profile_complete_screen";
  static const String emailVerificationScreen       = "/verify_email_screen";
  static const String smsVerificationScreen         = "/verify_sms_screen";
  static const String verifyPassCodeScreen          = "/verify_pass_code_screen";
  static const String resetPasswordScreen           = "/reset_pass_screen";
  static const String transactionHistoryScreen      = "/transaction_history_screen";
  static const String notificationScreen            = "/notification_screen";
  static const String profileScreen                 = "/profile_screen";
  static const String editProfileScreen             = "/edit_profile_screen";
  static const String kycScreen                     = "/kyc_screen";
  static const String privacyScreen                 = "/privacy-screen";
  static const String withdrawScreen                = "/withdraw-screen";
  static const String addWithdrawMethodScreen       = "/withdraw-method";
  static const String withdrawConfirmScreenScreen   = "/withdraw-preview-screen";
  static const String depositsScreen                = "/deposits";
  static const String depositsDetailsScreen         = "/deposits_details";
  static const String newDepositScreenScreen        = "/deposits_money";
  static const String depositWebViewScreen          = '/deposit_webView';
  static const String sendMoneyHistory              = '/send_money_history';
  static const String sendMoneyScreen               = '/send_money_screen';
  static const String sendMoneyHistoryDetailsScreen = '/send_money_history_details';
  static const String transactionScreen             = '/transection_screen';
  static const String onboardScreen                 = '/onboard_screen';
  static const String senderScreen                  = '/sender_screen';
  static const String recipientScreen               = '/recipient_screen';
  static const String twoFactorSetupScreen          = "/two-factor-setup-screen";
  static const String languageScreen                = "/languages_screen";
  static const String twoFactorScreen               = "/two-factor-screen";
  static const String faqScreen                     = "/faq-screen";
  static const String previewImageScreen            = "/preview-image-screen";
  static const String supportTicketMethodsList      = '/all_ticket_methods';
  static const String allTicketScreen               = '/all_ticket_screen';

  static const String ticketDetailsScreen = '/ticket_details_screen';

  static const String newTicketScreen = '/new_ticket_screen';

  List<GetPage> routes = [
    GetPage(name: splashScreen, page: () => const SplashScreen()),
    GetPage(name: loginScreen, page: () => const LoginScreen()),
    GetPage(name: forgotPasswordScreen, page: () => const ForgetPasswordScreen()),
    GetPage(name: changePasswordScreen, page: () => const ChangePasswordScreen()),
    GetPage(name: registrationScreen, page: () => const RegistrationScreen()),
    GetPage(name: profileCompleteScreen, page: () => const ProfileCompleteScreen()),
    GetPage(name: bottomNavBar, page: () => BottomNavBar2()),
    GetPage(name: profileScreen, page: () => const ProfileScreen()),
    GetPage(name: editProfileScreen, page: () => const EditProfileScreen()),
    GetPage(name: kycScreen, page: () => const KycScreen()),
    GetPage(name: twoFactorSetupScreen, page: () => const TwoFactorSetupScreen()),
    GetPage(name: twoFactorScreen, page: () => const TwoFactorVerificationScreen()),
    GetPage(name: depositWebViewScreen, page: () => MyWebViewScreen(redirectUrl: Get.arguments)),
    GetPage(name: newDepositScreenScreen, page: () => const NewDepositScreen()),
    GetPage(name: languageScreen, page: () => const LanguageScreen()),
    GetPage(name: emailVerificationScreen, page: () => const EmailVerificationScreen()),
    GetPage(name: smsVerificationScreen, page: () => const SmsVerificationScreen()),
    GetPage(name: verifyPassCodeScreen, page: () => const VerifyForgetPassScreen()),
    GetPage(name: resetPasswordScreen, page: () => const ResetPasswordScreen()),
    GetPage(name: faqScreen, page: () => const FaqScreen()),
    GetPage(name: kycScreen, page: () => const KycScreen()),
    GetPage(name: privacyScreen, page: () => const PrivacyPolicyScreen()),
    GetPage(name: previewImageScreen, page: () => PreviewImage(url: Get.arguments)),
    GetPage(name: sendMoneyHistory, page: () => const SendMoneyHistory()),
    GetPage(name: sendMoneyScreen, page: () => const SendMoneyScreen()),
    GetPage(name: sendMoneyHistoryDetailsScreen, page: () => const SendMoneyHistoryDetailsScreen()),
    GetPage(name: transactionScreen, page: () => const TransactionScreen()),
    GetPage(name: onboardScreen, page: () => const OnboardScreen()),
    GetPage(name: senderScreen, page: () => const SenderScreen()),
    GetPage(name: recipientScreen, page: () => const RecipientScreen()),
    GetPage(name: allTicketScreen, page: () => const AllTicketScreen()),
    GetPage(name: ticketDetailsScreen, page: () => const TicketDetailsScreen()),
    GetPage(name: newTicketScreen, page: () => const NewTicketScreen()),
  ];

  static Future<void> checkUserStatusAndGoToNextStep(User? user, {bool isRemember = false, String accessToken = "", String tokenType = ""}) async {
    bool needEmailVerification = user?.ev == "1" ? false : true;
    bool needSmsVerification = user?.sv == '1' ? false : true;
    bool isTwoFactorEnable = user?.tv == '1' ? false : true;

    SharedPreferences sharedPreferences = await SharedPreferences.getInstance();

    if (isRemember) {
      await sharedPreferences.setBool(SharedPreferenceHelper.rememberMeKey, true);
    } else {
      await sharedPreferences.setBool(SharedPreferenceHelper.rememberMeKey, false);
    }

    await sharedPreferences.setString(SharedPreferenceHelper.userIdKey, user?.id.toString() ?? '-1');
    await sharedPreferences.setString(SharedPreferenceHelper.userEmailKey, user?.email ?? '');
    await sharedPreferences.setString(SharedPreferenceHelper.userPhoneNumberKey, user?.mobile ?? '');
    await sharedPreferences.setString(SharedPreferenceHelper.userNameKey, user?.username ?? '');

    if (accessToken.isNotEmpty) {
      await sharedPreferences.setString(SharedPreferenceHelper.accessTokenKey, accessToken);
      await sharedPreferences.setString(SharedPreferenceHelper.accessTokenType, tokenType);
    }

    bool isProfileCompleteEnable = user?.profileComplete == '0' ? true : false;

    if (isProfileCompleteEnable) {
      Get.offAndToNamed(RouteHelper.profileCompleteScreen);
    } else if (needEmailVerification) {
      Get.offAndToNamed(RouteHelper.emailVerificationScreen);
    } else if (needSmsVerification) {
      Get.offAndToNamed(RouteHelper.smsVerificationScreen);
    } else if (isTwoFactorEnable) {
      Get.offAndToNamed(RouteHelper.twoFactorScreen);
    } else {
      PushNotificationService object = PushNotificationService(apiClient: Get.find());
      await object.sendUserToken();
      Get.offAndToNamed(RouteHelper.bottomNavBar);
    }
  }
}
